@extends('admin.layout.adminmaster')

@section('style1')
<style>
.form-control,
.form-select {
    font-size: 13px;
    padding: 6px 8px;
}

.table-sm td,
.table-sm th {
    padding: 6px 8px;
    font-size: 13px;
}

.measure-label {
    width: 45%;
    font-weight: 500;
    background: #f8f9fa;
}

.garment-box {
    border: 1px solid #dee2e6;
    border-radius: 6px;
    padding: 12px;
    margin-bottom: 14px;
    background: #fff;
}

.garment-title {
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 8px;
}
</style>
@endsection

@section('contentarea')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-10 col-xl-9">

<h4 class="mb-3">Edit Order #{{ $order->order_no ?? $order->id }}</h4>

<form method="POST" action="{{ route('admin.OrderManagement-update', $order->id) }}">
@csrf
@method('PUT')

<div class="row g-2 mb-3">
    <div class="col-md-6">
        <label class="form-label mb-1">Customer</label>
        <select class="form-select" name="customer_id">
            @foreach($customers as $customer)
                <option value="{{ $customer->id }}"
                    {{ $order->customer_id == $customer->id ? 'selected' : '' }}>
                    {{ $customer->name }}
                </option>
            @endforeach
        </select>
    </div>

    <div class="col-md-3">
        <label class="form-label mb-1">Advance</label>
        <input type="number"
               class="form-control"
               name="advance_amount"
               value="{{ $order->advance_amount }}">
    </div>

    <div class="col-md-3">
        <label class="form-label mb-1">Delivery Date</label>
        <input type="date"
               class="form-control"
               name="delivery_date"
               value="{{ $order->delivery_date }}">
    </div>
</div>

@foreach($order->items as $item)
<div class="garment-box">
    <div class="garment-title">
        {{ ucfirst($item->garment_type) }}
        <span class="text-muted fw-normal">
            (Profile: {{ $item->profile->profile_name ?? '-' }})
        </span>
    </div>

    <table class="table table-sm table-bordered">
        @foreach($item->measurement->measurements as $key => $value)
        <tr>
            <td class="measure-label">
                {{ $measurementLabels[$key] ?? ucfirst(str_replace('_',' ',$key)) }}
            </td>
            <td>
                <input type="text"
                       class="form-control form-control-sm"
                       name="items[{{ $item->id }}][measurements][{{ $key }}]"
                       value="{{ $value }}">
            </td>
        </tr>
        @endforeach
    </table>
</div>
@endforeach

<div class="text-end mt-3">
    <button class="btn btn-primary">
        Update Order
    </button>
</div>

</form>

        </div>
    </div>
</div>
@endsection
