 @extends('admin.layout.adminmaster')
@section('style1')
<style>
 .measure-input {
    height: 38px;
    font-size: 13px;
    text-align: center;
    border-radius: 6px;
    padding: 4px;
}
.measure-input::placeholder {
    font-size: 13px;        /* ⬅ slightly bigger */
    font-weight: 500;      /* ⬅ darker/thicker */
    color: #333;           /* ⬅ dark grey (near black) */
    opacity: 1;            /* ⬅ force full visibility */
}
.suggestion-box {
    position: absolute;
    top: 100%;
    left: 0;
    background: #fff;
    border: 1px solid #ccc;
    border-radius: 6px;
    max-height: 160px;
    overflow-y: auto;
    z-index: 99999;
    width: 100%;
}

.suggestion-item {
    padding: 6px 8px;
    cursor: pointer;
    font-size: 13px;
}

.suggestion-item:hover {
    background: #f1f1f1;
}
/* 🔽 SELECT BOX – DIFFERENT DESIGN */
.measure-select {
    height: 38px;
    font-size: 13px;
    border-radius: 6px;
    padding: 4px 8px;
    background-color: #f8f9fa;   /* light grey */
    border: 1px solid #999;
    font-weight: 600;
    text-align: center;
    cursor: pointer;
}

/* Arrow styling (modern look) */
.measure-select {
    appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg fill='none' stroke='%23333' stroke-width='2' viewBox='0 0 24 24' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M6 9l6 6 6-6'%3E%3C/path%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 8px center;
    background-size: 14px;
}

/* Placeholder option style */
.measure-select option[value=""] {
    color: #666;
}
</style>
@endsection
@section('contentarea')
<div class="container">

<h4>Create Order</h4>


{{-- ================= CUSTOMER INPUT ================= --}}
<div class="row mb-3 position-relative">

    <div class="col-md-4">
        <label>Customer Name</label>
        <input type="text"
               class="form-control"
               id="customerSearch"
               placeholder="Type customer name" required>

        <div id="customerResults"
             class="list-group position-absolute w-100 d-none"
             style="z-index:1000"></div>

        <input type="hidden" id="selectedCustomerId">
    </div>

    <div class="col-md-3">
       <button type="button"
        class="form-control btn btn-outline-primary mt-3"
        id="openAddCustomerBtn">
    + Add New Customer
    </button>
            </div>
  <div class="col-md-3">
    <button type="button"
                        class="form-control btn btn-primary mt-3"
                        id="addCustomerOrder">
                    + Add Garment
                </button>
                </div>

</div>

{{-- ================= GARMENT ================= --}}

<div id="garmentWrapper" class="d-none border p-3 mb-3">

    <h6>Garment</h6>

    <div class="row">
       <div class="col-md-3">
    <label>Customer Name</label>
    <input type="text"
           class="form-control"
           id="profileSearch"
           placeholder="Enter Profile name">
    <div id="profileResults"
         class="list-group position-absolute w-100 d-none"
         style="z-index:1000"></div>

    <input type="hidden" id="selectedProfileId">
</div>
<div class="col-md-3">
            <label>Garment Type</label>
       <select class="form-control garment-type" required>
    <option value="">Select Garment</option>
    <option value="Shirt">Shirt</option>
    <option value="Pant">Pant</option>
    <option value="Blouse">Blouse</option>
    <option value="Chudithar">Chudithar</option>
</select>
        </div>
        <div class="col-md-2">
    <label class="fw-semibold">Age Type</label><br>

    <div class="form-check form-check-inline">
        <input class="form-check-input age-type"
               type="radio"
               name="age_type"
               value="Adult">
        <label class="form-check-label">Adult</label>
    </div>

    <div class="form-check form-check-inline">
        <input class="form-check-input age-type"
               type="radio"
               name="age_type"
               value="Child">
        <label class="form-check-label">Child</label>
    </div>
</div>
            <div class="blouse-image mb-3 d-none">
        <img src="{{ asset('images/blouse-measurement.png') }}"
             class="img-fluid border rounded"
             alt="Blouse Measurement Guide">
    </div>

    </div>

    <div class="row mt-3 measurement-area"></div>
</div>
{{-- ================= SAVED LIST TABLE ================= --}}
<div class="mb-4">
    <table class="table table-bordered table-sm">
        <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Profile Name </th>
                <th>Garment</th>
                <th>Number of Clothes</th>
                <th>Total Amount</th>
                <th>Delivery Date</th>
            </tr>
        </thead>
        <tbody id="savedCustomers">
            <tr id="noDataRow">
                <td colspan="6" class="text-center text-muted">
                    No customer added yet
                </td>
            </tr>
        </tbody>
    </table>
</div>

<form onsubmit="return false;">
@csrf


{{-- ================= SAVED LIST ================= --}}




 <div class="card mt-3">
    <div class="card-header bg-light">
        <strong>Payment & Delivery</strong>
    </div>

    <div class="card-body">
        <div class="row align-items-end">

            <!-- Advance Amount -->
            <div class="col-md-3 mb-2">
                <div class="input-group">
                    <span class="input-group-text">₹</span>
                    <input type="number"
                           class="form-control"
                           id="advanceAmount"
                           placeholder="Advance Amount / முன்பணம்">
                </div>
            </div>

            <!-- Delivery Date -->
            <div class="col-md-3 mb-2">
                <input type="date"
                       class="form-control"
                       id="deliveryDate"
                       placeholder="Delivery Date / விநியோக தேதி"
                       required>
            </div>

            <!-- Actions -->
            <div class="col-md-3 mb-2">
                <button type="button"
                        class="form-control btn btn-success"
                        id="saveOrderBtn">
                    👁 Review Order
                </button>
            </div>

        </div>
    </div>
</div>


</form>
</div>
{{-- ================= CONFIRM MODAL ================= --}}
<div class="modal fade" id="confirmModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">Confirm Order Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body" id="confirmContent"></div>

      <div class="modal-footer">
        <button type="button" class="btn btn-secondary"
                data-bs-dismiss="modal">
            Cancel
        </button>
    <button type="button" class="btn btn-success" id="confirmSaveBtn">
    ✅ Submit Order
</button>
      </div>

    </div>
  </div>
</div>
{{--========== New customer Modal===================--}}

<div class="modal fade" id="addCustomerModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">Add New Customer</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <div class="mb-2">
            <label>Name</label>
            <input type="text" id="newCustomerName" class="form-control">
        </div>
        <div class="mb-2">
            <label>Phone</label>
            <input type="text" id="newCustomerPhone" class="form-control">
        </div>
      </div>

      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">
            Cancel
        </button>
        <button class="btn btn-success" id="saveNewCustomer">
            Save Customer
        </button>
      </div>

    </div>
  </div>
</div>
@endsection
@section('script1')
{{-- ================= JAVASCRIPT ================= --}}
<script>
const customers = @json($customers);
let orderItems = [];
let profiles = [];
function attachMeasurementSuggestions(input) {

    let box = null;

    input.addEventListener('focus', show);
    input.addEventListener('input', show);

    function show() {
        close();

        const wrapper = input.parentElement;
        wrapper.style.position = 'relative';

        box = document.createElement('div');
        box.className = 'suggestion-box';

        const query = input.value || '';

        measurementValues
            .filter(v => v.startsWith(query))
            .slice(0, 20)
            .forEach(val => {
                const item = document.createElement('div');
                item.className = 'suggestion-item';
                item.textContent = val;

                item.addEventListener('mousedown', () => {
                    input.value = val;
                    close();
                });

                box.appendChild(item);
            });

        if (box.children.length > 0) {
            wrapper.appendChild(box);
        }
    }

    function close() {
        if (box) {
            box.remove();
            box = null;
        }
    }

    document.addEventListener('click', e => {
        if (!input.contains(e.target)) close();
    });
}

function loadProfiles(customerId) {
    fetch(`/admin/customer/${customerId}/profiles`)
        .then(res => res.json())
        .then(res => {
            profiles = res.data || [];
        });
}
    function generateFractionMeasurements(max = 100) {
        const fractions = ['', '¼', '½', '¾'];
        const values = [];

        for (let i = 1; i <= max; i++) {
            fractions.forEach(f => {
                values.push(`${i}${f}`);
            });
        }
        return values;
    }

    // ✅ GLOBAL measurement values
    const measurementValues = generateFractionMeasurements(100);

/* ================= HELPERS ================= */
function showError(msg, el = null) {
    alert(msg);
    if (el) el.focus();
}
/* ================= CUSTOMER SEARCH ================= */
const profileInput = document.getElementById('profileSearch');
const profileResults = document.getElementById('profileResults');

profileInput.addEventListener('input', function () {

    profileResults.innerHTML = '';
    if (!this.value) {
        profileResults.classList.add('d-none');
        return;
    }

    profiles
        .filter(p => p.profile_name
        .toLowerCase()
        .includes(this.value.toLowerCase()))
        .forEach(p => {

            const item = document.createElement('a');
            item.className = 'list-group-item list-group-item-action';
            item.textContent = p.profile_name;

            item.onclick = () => {
                profileInput.value = p.profile_name;
                selectedProfileId.value = p.id;
                profileResults.classList.add('d-none');
            };

            profileResults.appendChild(item);
        });

    profileResults.classList.remove('d-none');
});

/* ================= CUSTOMER SEARCH ================= */
const searchInput = document.getElementById('customerSearch');
const resultsBox = document.getElementById('customerResults');
 const profileSearch = document.getElementById('profileSearch');
const garmentWrapper = document.getElementById('garmentWrapper');
const deliveryDate = document.getElementById('deliveryDate');

/* ================= CUSTOMER SEARCH ================= */
searchInput.addEventListener('input', function () {

    resultsBox.innerHTML = '';

    if (!this.value) {
        resultsBox.classList.add('d-none');
        return;
    }

    customers
        .filter(c => c.name.toLowerCase().includes(this.value.toLowerCase()))
        .forEach(c => {
            const item = document.createElement('a');
            item.className = 'list-group-item list-group-item-action';
            item.textContent = `${c.name} (${c.phone})`;

            item.onclick = () => {
                searchInput.value = `${c.name} (${c.phone})`;
                document.getElementById('selectedCustomerId').value = c.id;
                profileInput.value = c.name;
                loadProfiles(c.id);
                // garmentWrapper.classList.remove('d-none');
                resultsBox.classList.add('d-none');
            };

            resultsBox.appendChild(item);
        });

    resultsBox.classList.remove('d-none');
});
 const shirtFields = [

    // 🔹 SHIRT TYPE
    {
        type: 'radio',
        k: 'shirt_type',
        options: ['Full / முழு கை', 'Half / அரை கை']
    },

    // 🔹 MEASUREMENTS
    { k: 'height',        p: 'Height / உயரம்' },
    { k: 'shoulder',      p: 'Shoulder / தோள்' },
    { k: 'collar',        p: 'Collar / காலர்' },

    { k: 'kai_uyaram',    p: 'Sleeve / கை நீளம்' },
    { k: 'body_munaikai', p: 'Body 1 / முனைக்கை' },
    { k: 'body_munda',    p: 'Body 2 / முன்டை' },

    { k: 'side_loose_1',  p: 'Side 1 / ஓரம் 1' },
    { k: 'side_loose_2',  p: 'Side 2 / ஓரம் 2' },
    { k: 'side_loose_3',  p: 'Side 3 / ஓரம் 3' },

    { k: 'kappu',         p: 'Cuff / கப்பு' },

    // 🔹 STYLE OPTIONS
    {
        type: 'select',
        k: 'front_style',
        p: 'Front / முன்பக்கம்',
        options: ['B9', 'Normal', 'Hidden']
    },
    {
        type: 'select',
        k: 'model',
        p: 'Model / மாடல்',
        options: ['M1', 'M2', 'M3', 'M4']
    }
];

 const pantFields = [

    { type:'input', k:'uyaram',      p:'Uyaram / Length' },
    { type:'input', k:'iduppu',      p:'Iduppu / Waist' },

    { type:'input', k:'hi_hip',      p:'Hi Hip / மேல் இடுப்பு' },
    { type:'input', k:'low_hip',     p:'Low Hip / கீழ் இடுப்பு' },

    { type:'input', k:'seat',        p:'Seat / இருக்கை' },
    { type:'input', k:'thodai',      p:'Thodai / Thigh' },

    { type:'input', k:'mutti',       p:'Mutti / Knee' },
    { type:'input', k:'bottom',      p:'Bottom / கால்திறப்பு' },

    { type:'input', k:'zip_round',   p:'Zip Round / ஜிப் சுற்று' },

    {
        type:'select',
        k:'bottom_fit',
        p:'Bottom Fit',
        options:['Normal','Slim','Loose']
    },

    {
        type:'select',
        k:'model',
        p:'Model',
        options:['Regular','Slim','Ankle','Bell']
    }
];

const blouseFields = [
 {k:'blouse_back_length', l:'Blouse Back Length / பின்நீளம்'},
 {k:'full_shoulder', l:'Full Shoulder / முழு தோள்'},
 {k:'shoulder_strap', l:'Shoulder Strap / தோள் பட்டை'},
 {k:'back_neck_depth', l:'Back Neck Depth / பின் கழுத்து ஆழம்'},
 {k:'front_neck_depth', l:'Front Neck Depth / முன் கழுத்து ஆழம்'},
 {k:'shoulder_to_apex', l:'Shoulder to Apex / தோளிலிருந்து உச்சி'},
 {k:'front_length', l:'Front Length / முன் நீளம்'},
 {k:'chest_round', l:'Chest (Around) / மார்பு சுற்று'},
 {k:'waist_round', l:'Waist (Around) / இடுப்பு சுற்று'},
 {k:'sleeve_length', l:'Sleeve Length / கை நீளம்'},
 {k:'arm_round', l:'Arm Round / கை சுற்று'},
 {k:'sleeve_round', l:'Sleeve Round / கை முடிவு'},
 {k:'arm_hole', l:'Arm Hole / கை குழி'}
];

const chuditharTopFields = [
 {k:'top_length', l:'Full Length / முழு நீளம்'},
 {k:'shoulder', l:'Shoulder / தோள்'},
 {k:'bust_round', l:'Bust / Chest (Around) / மார்பு சுற்று'},
 {k:'waist_round', l:'Waist (Around) / இடுப்பு சுற்று'},
 {k:'hip_round', l:'Hips (Around) / இடுப்பு சுற்று'},
 {k:'sleeve_length', l:'Sleeve Length / கை நீளம்'},
 {k:'sleeve_round', l:'Sleeve Opening / கை முடிவு'},
 {k:'arm_hole', l:'Arm Hole / கை குழி'},
 {k:'neck_depth_front', l:'Neck Depth Front / முன் கழுத்து'},
 {k:'neck_depth_back', l:'Neck Depth Back / பின் கழுத்து'}
];
const chuditharBottomFields = [
 {k:'waist_round', l:'Waist / Lower Waist / இடுப்பு'},
 {k:'bottom_length', l:'Length / நீளம்'},
 {k:'thigh_round', l:'Thigh / தொடை'},
 {k:'knee_round', l:'Knee / முழங்கால்'},
 {k:'calf_round', l:'Calf / கால்வளை'},
 {k:'ankle_round', l:'Bottom Round / Ankle / கணுக்கால்'}
];
 document.addEventListener('change', function (e) {

    if (!e.target.classList.contains('garment-type')) return;

    const garmentType = e.target.value;
    const garmentBlock = e.target.closest('#garmentWrapper');
    const measurementArea = garmentBlock.querySelector('.measurement-area');
    const notes = document.querySelector('.garment-notes')?.value || '';
    const qty   = Number(document.querySelector('.garment-qty')?.value || 1);
    const total = Number(document.querySelector('.garment-total')?.value || 0);


    measurementArea.innerHTML = '';
    if (!garmentType) return;

    // ================= SHIRT =================
 if (garmentType === 'Shirt') {

    shirtFields.forEach(field => {

        // 🔹 RADIO → buttons (Full / Half கை)
     if (field.type === 'radio') {
    measurementArea.insertAdjacentHTML('beforeend', `
        <div class="col-md-4 col-4 mb-2 d-flex gap-2">
            ${field.options.map(opt => `
                <button type="button"
                        class="btn btn-outline-secondary measure-toggle"
                        onclick="setShirtType(this, '${field.k}', '${opt}')">
                    ${opt}
                </button>
            `).join('')}
            <input type="hidden"
                   class="measurement-input"
                   data-key="${field.k}">
        </div>
    `);
    return;
}

        // 🔹 SELECT (Front / Model)
   if (field.type === 'select') {
    measurementArea.insertAdjacentHTML('beforeend', `
        <div class="col-md-2 col-4 mb-2">
            <select class="form-control measure-select measurement-input"
                    data-key="${field.k}">
                <option value="">${field.p}</option>
                ${field.options.map(o =>
                    `<option value="${o}">${o}</option>`
                ).join('')}
            </select>
        </div>
    `);
    return;
}


        // 🔹 INPUT (Height, Shoulder, Collar...)
        measurementArea.insertAdjacentHTML('beforeend', `
            <div class="col-md-2 col-4 mb-2">
                <input type="text"
                       class="form-control measure-input measurement-input"
                       data-key="${field.k}"
                       placeholder="${field.p}"
                       list="measurementList">
            </div>
        `);
    });

    // 🔹 Reference Images (unchanged)
measurementArea.insertAdjacentHTML('beforeend', `
    <div class="col-3 mt-0  d-flex gap-2">
        <div id="imageContainer">
            <div class="input-group mb-2">
                <input type="file"
                       class="form-control reference-image"
                       name="reference_images[]"
                       accept="image/*"
                       placeholder="Reference Image">
                <button type="button"
                        class="btn btn-outline-primary addImageBtn">+</button>
            </div>
        </div>
    </div>
`);

    // 🔹 Notes / Qty / Total (unchanged)
    measurementArea.insertAdjacentHTML('beforeend', `
    <div class="col-12 mt-3 border-top pt-3">
        <div class="row">

            <div class="col-md-6 mb-2">
                <textarea class="form-control garment-notes"
                          rows="2"
                          placeholder="Notes / குறிப்புகள்"></textarea>
            </div>

            <div class="col-md-3 mb-2">
                <input type="number"
                       class="form-control garment-qty"
                        min="1"
                       placeholder="Qty / எண்ணிக்கை">
            </div>

            <div class="col-md-3 mb-2">
                <input type="number"
                       class="form-control garment-total"
                       placeholder="Total ₹ / தொகை">
            </div>

        </div>
    </div>
`);
measurementArea.querySelectorAll('.measurement-input').forEach(input => {
    attachMeasurementSuggestions(input);
});

    return;
}
    // ================= PANT =================
if (garmentType === 'Pant') {

    pantFields.forEach(field => {

        // 🔹 SELECT
        if (field.type === 'select') {
            measurementArea.insertAdjacentHTML('beforeend', `
                <div class="col-md-2 col-4 mb-2">
                    <select class="form-control measure-input measurement-input"
                            data-key="${field.k}">
                        <option value="">${field.p}</option>
                        ${field.options.map(o =>
                            `<option value="${o}">${o}</option>`
                        ).join('')}
                    </select>
                </div>
            `);
            return;
        }

        // 🔹 INPUT
        measurementArea.insertAdjacentHTML('beforeend', `
            <div class="col-md-2 col-4 mb-2">
                <input type="text"
                       class="form-control measure-input measurement-input"
                       data-key="${field.k}"
                       placeholder="${field.p}"
                       list="measurementList">
            </div>
        `);
    });

    return;
}


    // ================= BLOUSE =================

    if (garmentType === 'Blouse') {
        blouseFields.forEach(field => {
            measurementArea.insertAdjacentHTML('beforeend', `
                <div class="col-md-3 mb-2">
                    <label>${field.l}</label>
                     <div class="row g-1">
                    <div class="col-7">
                        <input type="text"
                               class="form-control measurement-input"
                               data-key="${field.k}"
                                 list="measurementList">
                    </div>
                    </div>
                     </div>
            `);
        });
         measurementArea.insertAdjacentHTML('beforeend', `
    <div class="col-12 mt-3 border-top pt-3">
        <div class="row">

            <div class="col-md-6 mb-2">
                <label class="fw-semibold">Notes</label>
                <textarea class="form-control garment-notes"
                          rows="2"
                          placeholder="Any special instructions"></textarea>
            </div>

            <div class="col-md-3 mb-2">
                <label class="fw-semibold">No of Clothes</label>
                <input type="number"
                       class="form-control garment-qty"
                       value="1"
                       min="1">
            </div>

            <div class="col-md-3 mb-2">
                <label class="fw-semibold">Total Amount</label>
                <input type="number"
                       class="form-control garment-total"
                       placeholder="₹ Amount">
            </div>

        </div>
    </div>
`);

        return;
    }


    // ================= CHUDITHAR =================
    if (garmentType === 'Chudithar') {

        // ---- TOP (KAMEEZ) ----
        measurementArea.insertAdjacentHTML('beforeend', `
            <div class="col-12 mt-3">
                <h6 class="text-primary">Top (Kameez)</h6>
                <hr>
            </div>
        `);

       chuditharTopFields.forEach(field => {
    measurementArea.insertAdjacentHTML('beforeend', `
        <div class="col-md-4 mb-2">
            <label class="fw-semibold">${field.l}</label>
            <div class="row g-1">
                <div class="col-7">
                    <input type="text"
                           class="form-control measurement-input"
                           data-key="top_${field.k}"
                               list="measurementList">
                </div>

            </div>
        </div>
    `);
});

        // ---- BOTTOM (CHURIDAR PANT) ----
        measurementArea.insertAdjacentHTML('beforeend', `
            <div class="col-12 mt-4">
                <h6 class="text-success">Bottom (Churidar Pant)</h6>
                <hr>
            </div>
        `);

        chuditharBottomFields.forEach(field => {
            measurementArea.insertAdjacentHTML('beforeend', `
                <div class="col-md-3 mb-2">
                    <label>${field.l}</label>
                     <div class="row g-1">
                    <div class="col-7">
                      <input type="text"class="form-control measurement-input" data-key="${field.k}"
                        list="measurementList" placeholder="Type 1, 2, 3...">
                    </div>

                </div>

            `);
        });
         measurementArea.insertAdjacentHTML('beforeend', `
    <div class="col-12 mt-3 border-top pt-3">

        <div class="row"><div class="col-md-4 mb-2">
    <label class="fw-semibold">Add-On</label>
    <select class="form-control addon-select">
        <option value="">-- Select Add-On --</option>
        @foreach($addons as $addon)
            <option value="{{ $addon->id }}"
                    data-price="{{ $addon->price }}">
                {{ $addon->name }} (₹{{ $addon->price }})
            </option>
        @endforeach
    </select>
</div>

            <div class="col-md-6 mb-2">
                <label class="fw-semibold">Notes</label>
                <textarea class="form-control garment-notes"
                          rows="2"
                          placeholder="Any special instructions"></textarea>
            </div>

            <div class="col-md-3 mb-2">
                <label class="fw-semibold">No of Clothes</label>
                <input type="number"
                       class="form-control garment-qty"
                       value="1"
                       min="1">
            </div>

            <div class="col-md-3 mb-2">
                <label class="fw-semibold">Total Amount</label>
                <input type="number"
                       class="form-control garment-total"
                       placeholder="₹ Amount">
            </div>

        </div>
    </div>
`);
    }
});



/* ================= ADD CUSTOMER ORDER ================= */
document.getElementById('addCustomerOrder').onclick = () => {

    const customerId  = document.getElementById('selectedCustomerId').value;
    const garmentType = document.querySelector('.garment-type')?.value;

    if (!customerId) {
        alert('Please select customer first');
        return;
    }

    // 🟢 If garment already selected → SAVE current garment
    if (garmentType) {
        addMeasurementsForCurrentPerson();
        return;
    }

    // 🟢 Otherwise → just open garment section
    garmentWrapper.classList.remove('d-none');
};

/* ================= SAVE ORDER (POPUP) ================= */
document.getElementById('saveOrderBtn').onclick = () => {

    if (orderItems.length === 0) {
        alert('Please add at least one garment');
        return;
    }

    let html = '';

    orderItems.forEach((item, index) => {
        html += `
            <div class="border p-3 mb-3">
                <h6>${index + 1}. ${item.customer_name} – ${item.garment_type}</h6>

                <table class="table table-sm table-bordered">
                    <tbody>
        `;

        Object.keys(item.measurements).forEach(key => {
            html += `
                <tr>
                    <td>${key.replace(/[_]/g, ' ')}</td>
                    <td>${item.measurements[key]}</td>
                </tr>
            `;
        });

        html += `
                    </tbody>
                </table>
            </div>
        `;
    });

    document.getElementById('confirmContent').innerHTML = html;

    new bootstrap.Modal(
        document.getElementById('confirmModal')
    ).show();
};


/* ================= CONFIRM SAVE ================= */
document.getElementById('confirmSaveBtn').onclick = () => {

    const formData = new FormData();

    formData.append(
        'customer_id',
        document.getElementById('selectedCustomerId').value
    );
    formData.append(
        'advance_amount',
        document.getElementById('advanceAmount').value || 0
    );
    formData.append(
        'delivery_date',
        document.getElementById('deliveryDate').value
    );

    orderItems.forEach((item, index) => {

        formData.append(`garments[${index}][profile_id]`, item.profile_id);
        formData.append(`garments[${index}][profile_name]`, item.profile_name);
        formData.append(`garments[${index}][type]`, item.garment_type);

        Object.keys(item.measurements).forEach(key => {
            formData.append(
                `garments[${index}][measurement][${key}]`,
                item.measurements[key]
            );
        });

        const imageInputs = document.querySelectorAll(
            `input[name="garments[${index}][images][]"]`
        );

        imageInputs.forEach(input => {
            [...input.files].forEach(file => {
                formData.append(`garments[${index}][images][]`, file);
            });
        });
    });

    fetch("{{ route('admin.OrderManagement-store') }}", {
        method: "POST",
        headers: {
            "X-CSRF-TOKEN": document
                .querySelector('meta[name="csrf-token"]')
                .getAttribute('content')
        },
        body: formData
    })
    .then(res => res.json())
    .then(res => {

        if (!res.success) {
            alert('Order save failed');
            return;
        }

        // ✅ SUCCESS
        alert('Order saved successfully');

        // ✅ RESET EVERYTHING
        resetForm();

        // ✅ CLOSE MODAL
        bootstrap.Modal
            .getInstance(document.getElementById('confirmModal'))
            .hide();
    })
    .catch(() => alert('Server error'));
};


function setShirtType(btn, key, value) {
    // set value to hidden input
    const hidden = btn.parentElement.querySelector(
        `input[data-key="${key}"]`
    );
    if (hidden) hidden.value = value;

    // UI active state
    btn.parentElement.querySelectorAll('button')
        .forEach(b => b.classList.remove('active'));

    btn.classList.add('active');
}
/* ================= RESET ================= */
function resetForm() {
 // Clear JS data
    orderItems = [];

    // Clear table
    document.getElementById('savedCustomers').innerHTML = `
        <tr id="noDataRow">
            <td colspan="6" class="text-center text-muted">
                No customer added yet
            </td>
        </tr>
    `;

    // Clear inputs
    document.getElementById('customerSearch').value = '';
    document.getElementById('profileSearch').value = '';
    document.getElementById('selectedCustomerId').value = '';
    document.getElementById('selectedProfileId').value = '';
    document.getElementById('advanceAmount').value = '';
    document.getElementById('deliveryDate').value = '';

    // Hide garment section
    document.getElementById('garmentWrapper').classList.add('d-none');

    // Clear measurements
    document.querySelector('.measurement-area').innerHTML = '';

    // Clear images
    // document.getElementById('imageContainer').innerHTML = `
    //     <div class="input-group mb-2">
    //         <input type="file"
    //                class="form-control reference-image"
    //                accept="image/*">
    //         <button type="button"
    //                 class="btn btn-outline-primary addImageBtn">+</button>
    //     </div>
    // `;
}

document.addEventListener('DOMContentLoaded', function () {
   // ================= REQUIRED ELEMENTS =================
const customerSearch   = document.getElementById('customerSearch');
    const profileInput  = document.getElementById('profileSearch');
    const advanceAmount = document.getElementById('advanceAmount');
    const garmentWrapper = document.getElementById('garmentWrapper');
    const resultsBox     = document.getElementById('customerResults');

            // Fill datalist once
        const datalist = document.getElementById('measurementList');

        // measurementValues.forEach(val => {
        //     const option = document.createElement('option');
        //     option.value = val;
        //     datalist.appendChild(option);
        // });

    const addCustomerModal = new bootstrap.Modal(
        document.getElementById('addCustomerModal')
    );
  attachImageButtonListeners();
    // ================= OPEN ADD CUSTOMER MODAL =================
    const openBtn = document.getElementById('openAddCustomerBtn');

    openBtn.addEventListener('click', function () {

        document.getElementById('newCustomerName').value =
            customerSearch.value || '';

        document.getElementById('newCustomerPhone').value = '';

        addCustomerModal.show(); // ✅ NOW THIS WILL WORK
    });

    // customers array already defined from blade:

    customers.forEach(c => {
    if (!c.phone && c.mobile) {
        c.phone = c.mobile;
    }
});



    /* SAVE NEW CUSTOMER (AJAX) */
    document.getElementById('saveNewCustomer').onclick = () => {

        const name  = document.getElementById('newCustomerName').value.trim();
        const phone = document.getElementById('newCustomerPhone').value.trim();

        if (!name || !phone) {
            alert('Please enter name and phone');
            return;
        }

        fetch("{{ route('admin.CustomerManagement-ajaxStore') }}", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "X-CSRF-TOKEN": document
                    .querySelector('meta[name="csrf-token"]')
                    .getAttribute('content')
            },
            body: JSON.stringify({ name, phone })
        })
        .then(res => res.json())
        .then(res => {

            if (!res.success) {
                alert('Customer save failed');
                return;
            }

            // ✅ ADD TO AUTOCOMPLETE LIST
            customers.push(res.data);

            // ✅ AUTO SELECT CUSTOMER
            searchInput.value = res.data.name;
            profileInput.value = res.data.name;
            document.getElementById('selectedCustomerId').value = res.data.id;

            // ✅ OPEN GARMENT SECTION

            resultsBox.classList.add('d-none');

            addCustomerModal.hide();
        })
      .catch(() => alert('Server error'));
    };
/* ================= ADD MORE IMAGES ================= */
function attachImageButtonListeners() {
    document.addEventListener('click', function (e) {

        // ➕ ADD IMAGE
        if (e.target.classList.contains('addImageBtn')) {

            const container = document.getElementById('imageContainer');
            if (!container) return;

            const div = document.createElement('div');
            div.className = 'input-group mb-2';

            div.innerHTML = `
                <input type="file"
                       class="form-control reference-image"
                       name="reference_images[]"
                       accept="image/*">

                <button type="button"
                        class="btn btn-outline-danger removeImageBtn">
                    ×
                </button>
            `;

            container.appendChild(div);
        }

        // ❌ REMOVE IMAGE
        if (e.target.classList.contains('removeImageBtn')) {
            e.target.closest('.input-group').remove();
        }
    });
}

window.addMeasurementsForCurrentPerson = function () {

    const customerId   = document.getElementById('selectedCustomerId').value;
    const customerName = customerSearch.value;
    const profileName  = profileInput.value;
    const profileId    = document.getElementById('selectedProfileId').value;
    const garmentType  = document.querySelector('.garment-type').value;
    const garmentQty = document.querySelector('.garment-qty').value;
    const garmentTotal  = document.querySelector('.garment-total').value;
    const deliveryDate = document.getElementById('deliveryDate').value;

    const ageType = document.querySelector('.age-type:checked')?.value;
    const addonId = document.querySelector('.addon-select')?.value || null;

    if (!customerId || !profileName || !garmentType || !ageType) {
        alert('Please select customer, profile, garment & age');
        return;
    }

    let measurements = {};
    document.querySelectorAll('.measurement-input').forEach(input => {
        measurements[input.dataset.key] = input.value;
    });

    if (Object.values(measurements).every(v => !v)) {
        alert('Please enter measurements');
        return;
    }

    // ✅ SAVE DATA
     orderItems.push({
        customer_id: customerId,
        customer_name: customerName,
        profile_id: profileId,
        profile_name: profileName,
        garment_type: garmentType,
        age_type: ageType,
        qty: garmentQty,
        total_amount: garmentTotal,
        addon_id: addonId,
        delivery_date: deliveryDate,
        measurements
    });
    // ✅ UPDATE TABLE
    document.getElementById('noDataRow')?.remove();
    document.getElementById('savedCustomers').insertAdjacentHTML('beforeend', `
        <tr>

            <td>${orderItems.length}</td>
            <td>
                ${customerName}<br>
                <span class="badge bg-info">${ageType}</span>
            </td>
            <td>${garmentType}<br><small>${profileName}</small></td>
            <td>${garmentQty}</td>
            <td>₹ ${garmentTotal}</td>
            <td>${deliveryDate}</td>

        </tr>
    `);

    // ✅ RESET FOR NEXT PERSON
    resetMeasurementsOnly();

    // ✅ KEEP FORM OPEN FOR NEXT ENTRY
    garmentWrapper.classList.remove('d-none');
}

function resetMeasurementsOnly() {
    profileInput.value = '';
    document.getElementById('selectedProfileId').value = '';
    document.querySelector('.garment-type').value = '';
    document.querySelector('.measurement-area').innerHTML = '';
}
document.addEventListener('change', e => {
    if (e.target.classList.contains('garment-type')) {
        document.getElementById('addCustomerOrder').innerText =
            '➕ Save & Add Another Garment';
    }
});
document.addEventListener('change', function (e) {

    if (!e.target.classList.contains('age-type')) return;

    const ageType    = e.target.value;
    const garment    = document.querySelector('.garment-type').value;
    const totalInput = document.querySelector('.garment-total');

    if (!garment) {
        alert('Select garment first');
        return;
    }

    // 🔹 Fetch base price from settings
    fetch(`/admin/settings/price?garment=${garment}&age=${ageType}`)
        .then(res => res.json())
        .then(res => {
            totalInput.value = res.price || 0;
        });
});
document.addEventListener('change', function (e) {

    if (!e.target.classList.contains('addon-select')) return;

    const addonPrice = Number(
        e.target.selectedOptions[0].dataset.price || 0
    );

    const totalInput = document.querySelector('.garment-total');
    const basePrice  = Number(totalInput.value || 0);

    totalInput.value = basePrice + addonPrice;
});


});

</script>

@endsection
