@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="container">

    <div class="d-flex justify-content-between mb-3">
        <h4>Measurement Management</h4>
        <a href="{{ route('admin.MeasurementManagement-create') }}" class="btn btn-primary">
            + Add Measurement
        </a>
    </div>

    <table class="table table-bordered">
        <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Customer</th>
                <th>Garment</th>
                <th>Created</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($measurements as $measurement)
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $measurement->customer->name }}</td>
                <td>{{ $measurement->garment_type }}</td>
                <td>{{ $measurement->created_at->format('d-m-Y') }}</td>
                <td>
                    <a href="{{ route('admin.MeasurementManagement-show', $measurement) }}" class="btn btn-sm btn-info">View</a>
                    <a href="{{ route('admin.MeasurementManagement-edit', $measurement) }}" class="btn btn-sm btn-warning">Edit</a>
                             <a href="{{ route('admin.MeasurementManagement-destroy', $measurement) }}" class="btn btn-sm btn-warning">Delete</a>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    {{ $measurements->links() }}
</div>
@endsection
