@extends('admin.layout.adminmaster')

@section('contentarea')

<div class="row g-3">

    <div class="col-md-4">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <h6>Today Orders</h6>
                <h3>{{ $data['todayOrders'] }}</h3>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card text-white bg-success">
            <div class="card-body">
                <h6>Today Received Amount</h6>
                <h3>₹ {{ number_format($data['todayReceivedAmount'], 2) }}</h3>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card text-white bg-info">
            <div class="card-body">
                <h6>Today Delivered Orders</h6>
                <h3>{{ $data['todayDeliveredOrders'] }}</h3>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <h6>Overdue Orders</h6>
                <h3>{{ $data['overdueOrders'] }}</h3>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card text-dark bg-warning">
            <div class="card-body">
                <h6>Today Expected Orders</h6>
                <h3>{{ $data['todayExpectedOrders'] }}</h3>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card text-white bg-secondary">
            <div class="card-body">
                <h6>Undelivered Orders</h6>
                <h3>{{ $data['undeliveredOrders'] }}</h3>
            </div>
        </div>
    </div>

</div>

@endsection
