@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="container">
    <h3>Edit Customer</h3>

    <form method="POST" action="{{ route('admin.CustomerManagement-update',$customer->id) }}" id="customerForm">
        @csrf
        @method('PUT')
   <div class="col-md-6 mb-3">
    <label>Name</label>
    <input type="text" name="name" class="form-control"
           value="{{ old('name', $customer->name ?? '') }}">
           <small class="text-danger" id="nameError"></small>
</div>

<div class="col-md-6  mb-3">
    <label>Phone</label>
    <input type="text" name="phone" class="form-control"
           value="{{ old('phone', $customer->phone ?? '') }}">
    <small class="text-danger" id="phoneError"></small>

</div>

<div class="col-md-6  mb-3">
    <label>Email</label>
    <input type="email" name="email" class="form-control"
           value="{{ old('email', $customer->email ?? '') }}">
    <small class="text-danger" id="emailError"></small>

</div>
<div class="col-md-6  mb-3">
    <label>Address</label>
    <textarea name="address" class="form-control">{{ old('address', $customer->address ?? '') }}</textarea>
</div>

<div class="col-md-6  mb-3">
    <label>VIP Customer</label>
    <input type="checkbox" name="is_vip" value="1"
        {{ old('is_vip', $customer->is_vip ?? false) ? 'checked' : '' }}>
</div>
        <button class="btn btn-primary">Update</button>
    </form>
</div>
@endsection

@section('script2')
<script>
$(document).ready(function () {

    // 🔹 Custom rule: phone already exists
    $.validator.addMethod("phoneExists", function (value, element) {
        let valid = true;

        $.ajax({
            url: "{{ route('admin.customer.checkPhone') }}",
            type: "GET",
            data: { phone: value },
            dataType: "json",
            async: false, // IMPORTANT for validation
            success: function (response) {
                if (response.exists) {
                    valid = false;
                }
            }
        });

        return valid;
    }, "Phone number already exists");

    // 🔹 Apply validation
    $("#customerForm").validate({
        ignore: [],
        rules: {
            name: {
                required: true
            },
            phone: {
                required: true,
                digits: true,
                minlength: 10,
                maxlength: 10,
                phoneExists: true
            },
            email: {
                email: true
            },
            address: {
                required: true
            }
        },
        messages: {
            name: {
                required: "Please enter customer name"
            },
            phone: {
                required: "Please enter phone number",
                digits: "Phone must contain only digits",
                minlength: "Phone must be 10 digits",
                maxlength: "Phone must be 10 digits",
                phoneExists: "Phone number already exists"
            },
            email: {
                email: "Please enter a valid email address"
            },
            address: {
                required: "Please enter address"
            }
        },

        // 🔹 Place error below input (like your design)
        errorPlacement: function (error, element) {
            element.closest('.mb-3').find('small.text-danger').html(error);
        },

        // 🔹 Clear error on success
        success: function (label, element) {
            $(element).closest('.mb-3').find('small.text-danger').html('');
        }
    });

});
</script>
@endsection


