@extends('admin.layout.adminmaster')

@section('style1')
<style>
    #map {
        height: 500px;
        width: 100%;
        margin-top: 20px;
        border: 1px solid #ddd;
        border-radius: 4px;
    }
    .pac-container {
        z-index: 1051 !important;
    }
  
</style>
@endsection

@section('contentarea')
<div class="container mt-4">
    <h4>Route Picker</h4>
    <form action="{{ route('admin.BookingManagement-store') }}" method="POST" enctype="multipart/form-data" name="booking_form" id="booking_form" onsubmit="return validateForm();">
        @csrf

        <div class="row g-2">
            <div class="mb-3 col-md-6">
                <label for="notify_driver" class="form-label">Notify Driver(s)</label>
                <select id="notify_driver" class="form-select" name="notify_driver" onchange="toggleDriverRequirement()">
                    <option value="" disabled selected>---Select Notify Driver(s)--</option>
                    <option value="single">Single</option>
                    <option value="all">All</option>
                </select>        
            </div>
            
            <div class="mb-3 col-md-6">
                <label for="traveltype" class="form-label">Travel Type</label>
                <select id="traveltype" class="form-select" name="traveltype">
                    <option value="" disabled selected>---Select traveltype(s)--</option>
                    @foreach($traveltype as $types)
                    <option value="{{ $types->id }}">{{ $types->package_name }}</option>
                   @endforeach
                </select>        
            </div>
        </div>

        <input type="hidden" name="driver_id" id="driver_id">

    
        <div class="row g-2">
            <div class="mb-3 col-md-6">
                <label for="customer_name" class="form-label">Customer Name</label>
                <input type="text" id="customer_name" name="customer_name" class="form-control">
            </div>
            <div class="mb-3 col-md-6">
                <label for="phone" class="form-label">Phone Number</label>
                <input class="form-control" type="text" id="phone"  name="phone" autocomplete="new-phone">
            </div>
        </div>

        <div class="row g-2">

                <div class="col-md-6">
                    <label class="form-label">From Location</label>
                    <input type="text" id="fromAddress" name="from_address" class="form-control" placeholder="Enter starting location">
                    <input type="hidden" id="fromLatitude" name="from_latitude">
                    <input type="hidden" id="fromLongitude" name="from_longitude">
                </div>
                <div class="col-md-6">
                    <label class="form-label">To Location</label>
                    <input type="text" id="toAddress" name="to_address" class="form-control" placeholder="Enter destination location">
                    <input type="hidden" id="toLatitude" name="to_latitude">
                    <input type="hidden" id="toLongitude" name="to_longitude">
                </div>
            </div>
        

        <div id="map"></div>

        <div class="mt-4 mb-3" style="float: right">
            <button type="submit" class="btn btn-primary">Save Route</button>
        </div>
    </form>
</div>
@endsection

@section('script1')
<script>
    let drivers = @json($drivers);
    let map;
    let fromMarker;
    let toMarker;
    let directionsService;
    let directionsRenderer;
    let fromAutocomplete;
    let toAutocomplete;
    let fromLocation = null;
    let toLocation = null;
    let geocoder;
    let selectedDriverMarker = null; // Track selected driver marker

    function initMap() {
        const initialLocation = { lat: 9.9252, lng: 78.1198 };

        map = new google.maps.Map(document.getElementById("map"), {
            center: initialLocation,
            zoom: 13,
            streetViewControl: false,
            mapTypeControlOptions: {
                style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
                position: google.maps.ControlPosition.TOP_RIGHT
            }
        });

        geocoder = new google.maps.Geocoder();
        directionsService = new google.maps.DirectionsService();
        directionsRenderer = new google.maps.DirectionsRenderer({
            map: map,
            suppressMarkers: true,
            polylineOptions: {
                strokeColor: "#3a86ff",
                strokeOpacity: 0.8,
                strokeWeight: 5
            }
        });

        fromAutocomplete = new google.maps.places.Autocomplete(
            document.getElementById("fromAddress"),
            { fields: ["formatted_address", "geometry"], componentRestrictions: { country: "in" } }
        );

        toAutocomplete = new google.maps.places.Autocomplete(
            document.getElementById("toAddress"),
            { fields: ["formatted_address", "geometry"], componentRestrictions: { country: "in" } }
        );

        fromAutocomplete.addListener("place_changed", function () {
            const place = fromAutocomplete.getPlace();
            if (!place.geometry) {
                alert("No details available for input: '" + place.name + "'");
                return;
            }

            fromLocation = place.geometry.location;
            updateFromLocation(place.geometry.location, place.formatted_address);
            updateFormFields();
            updateRoute();

            if (window.fromLocationCircle) {
                window.fromLocationCircle.setMap(null);
            }

            window.fromLocationCircle = new google.maps.Circle({
                strokeColor: "#007bff",
                strokeOpacity: 0.8,
                strokeWeight: 2,
                fillColor: "#007bff",
                fillOpacity: 0.2,
                map: map,
                center: fromLocation,
                radius: 3000
            });

            map.panTo(fromLocation);
            map.fitBounds(window.fromLocationCircle.getBounds());

            fetch("{{ route('admin.getNearbyDrivers') }}", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": '{{ csrf_token() }}',
                },
                body: JSON.stringify({
                    latitude: fromLocation.lat(),
                    longitude: fromLocation.lng()
                })
            })
                .then(res => res.json())
                .then(drivers => {
                    drivers.forEach(driver => {
                        const marker = new google.maps.Marker({
                            position: { lat: parseFloat(driver.latitude), lng: parseFloat(driver.longitude) },
                            map: map,
                            icon: {
                                url: "https://img.icons8.com/emoji/48/oncoming-taxi.png",
                                scaledSize: new google.maps.Size(32, 32)
                            },
                            title: driver.driver_name
                        });

                        marker.addListener('click', () => {
                            selectDriverFromMap(driver.id, marker);
                        });
                    });
                })
                .catch(error => {
                    console.error("Error fetching nearby drivers:", error);
                });


                if (place.address_components) {
                let country = '', state = '', city = '';
                place.address_components.forEach(component => {
                    if (component.types.includes('country')) country = component.long_name;
                    if (component.types.includes('administrative_area_level_1')) state = component.long_name;
                    if (component.types.includes('locality') || component.types.includes('administrative_area_level_2')) city = component.long_name;
                });

                console.log('From Location Details:', { country, state, city });
            }
        });

        toAutocomplete.addListener("place_changed", function () {
            const place = toAutocomplete.getPlace();
            if (!place.geometry) {
                alert("No details available for input: '" + place.name + "'");
                return;
            }

            toLocation = place.geometry.location;
            updateToLocation(place.geometry.location, place.formatted_address);
            updateFormFields();
            updateRoute();

            if (place.address_components) {
                let country = '', state = '', city = '';
                place.address_components.forEach(component => {
                    if (component.types.includes('country')) country = component.long_name;
                    if (component.types.includes('administrative_area_level_1')) state = component.long_name;
                    if (component.types.includes('locality') || component.types.includes('administrative_area_level_2')) city = component.long_name;
                });

                console.log('From Location Details:', { country, state, city });
            }
        });

        map.addListener("click", function (e) {
            geocoder.geocode({ location: e.latLng }, (results, status) => {
                if (status === "OK" && results[0]) {
                    const address = results[0].formatted_address;

                    if (!fromLocation) {
                        fromLocation = e.latLng;
                        updateFromLocation(e.latLng, address);
                        document.getElementById("fromAddress").value = address;
                    } else if (!toLocation) {
                        toLocation = e.latLng;
                        updateToLocation(e.latLng, address);
                        document.getElementById("toAddress").value = address;
                    } else {
                        fromLocation = e.latLng;
                        toLocation = null;
                        updateFromLocation(e.latLng, address);
                        document.getElementById("fromAddress").value = address;
                        document.getElementById("toAddress").value = "";
                        if (toMarker) {
                            toMarker.setMap(null);
                            toMarker = null;
                        }
                    }

                    updateFormFields();
                    updateRoute();
                }
            });
        });

        const fromLat = document.getElementById("fromLatitude").value;
        const fromLng = document.getElementById("fromLongitude").value;
        if (fromLat && fromLng) {
            fromLocation = new google.maps.LatLng(parseFloat(fromLat), parseFloat(fromLng));
            updateFromLocation(fromLocation, document.getElementById("fromAddress").value);
        }

        const toLat = document.getElementById("toLatitude").value;
        const toLng = document.getElementById("toLongitude").value;
        if (toLat && toLng) {
            toLocation = new google.maps.LatLng(parseFloat(toLat), parseFloat(toLng));
            updateToLocation(toLocation, document.getElementById("toAddress").value);
        }

        if (fromLocation && toLocation) {
            updateRoute();
        }

        // Add initial static driver markers
        drivers.forEach(driver => {
            const marker = new google.maps.Marker({
                position: {
                    lat: parseFloat(driver.current_latitude),
                    lng: parseFloat(driver.current_longitude)
                },
                map: map,
                icon: {
                    url: "https://img.icons8.com/emoji/48/oncoming-taxi.png",
                    scaledSize: new google.maps.Size(32, 32)
                },
                title: 'Driver ID: ' + driver.id
            });

            marker.addListener('click', () => {
                selectDriverFromMap(driver.id, marker);
            });
        });
    }

    function selectDriverFromMap(driverId, marker) {
        document.getElementById('driver_id').value = driverId;

        if (selectedDriverMarker) {
            selectedDriverMarker.setIcon({
                url: "https://img.icons8.com/emoji/48/oncoming-taxi.png",
                scaledSize: new google.maps.Size(32, 32)
            });
        }

        marker.setIcon({
            url: "https://maps.google.com/mapfiles/ms/icons/blue-dot.png",
            scaledSize: new google.maps.Size(40, 40)
        });

        selectedDriverMarker = marker;
    }

    function validateForm() {
        const notifyType = document.getElementById('notify_driver').value;
        const driverId = document.getElementById('driver_id').value;

        if (notifyType === 'single' && !driverId) {
            alert('You selected single driver notification. Please select a driver on the map.');
            return false;
        }

        return true;
    }

    function toggleDriverRequirement() {
        const type = document.getElementById('notify_driver').value;
        if (type === 'all') {
            document.getElementById('driver_id').value = '';
        }
    }

    function updateFromLocation(location, address = null) {
        if (fromMarker) {
            fromMarker.setMap(null);
        }

        fromMarker = new google.maps.Marker({
            position: location,
            map: map,
            title: "From Location",
            draggable: true,
            icon: {
                url: "http://maps.google.com/mapfiles/ms/icons/green-dot.png",
                scaledSize: new google.maps.Size(32, 32)
            }
        });

        fromMarker.addListener("dragend", function () {
            geocoder.geocode({ location: fromMarker.getPosition() }, (results, status) => {
                if (status === "OK" && results[0]) {
                    document.getElementById("fromAddress").value = results[0].formatted_address;
                    updateFormFields();
                    updateRoute();
                }
            });
        });

        if (!toLocation) {
            map.setCenter(location);
            map.setZoom(15);
        }
    }

    function updateToLocation(location, address = null) {
        if (toMarker) {
            toMarker.setMap(null);
        }

        toMarker = new google.maps.Marker({
            position: location,
            map: map,
            title: "To Location",
            draggable: true,
            icon: {
                url: "http://maps.google.com/mapfiles/ms/icons/red-dot.png",
                scaledSize: new google.maps.Size(32, 32)
            }
        });

        toMarker.addListener("dragend", function () {
            geocoder.geocode({ location: toMarker.getPosition() }, (results, status) => {
                if (status === "OK" && results[0]) {
                    document.getElementById("toAddress").value = results[0].formatted_address;
                    updateFormFields();
                    updateRoute();
                }
            });
        });

        if (fromLocation) {
            const bounds = new google.maps.LatLngBounds();
            bounds.extend(fromLocation);
            bounds.extend(location);
            map.fitBounds(bounds);
        }
    }

    function updateRoute() {
        if (!fromLocation || !toLocation) return;

        directionsService.route(
            {
                origin: fromLocation,
                destination: toLocation,
                travelMode: google.maps.TravelMode.DRIVING,
                provideRouteAlternatives: true
            },
            (response, status) => {
                if (status === "OK") {
                    directionsRenderer.setDirections(response);
                } else {
                    alert("Directions request failed due to " + status);
                }
            }
        );
    }

    function updateFormFields() {
        if (fromLocation) {
            document.getElementById("fromLatitude").value = fromLocation.lat();
            document.getElementById("fromLongitude").value = fromLocation.lng();
        }

        if (toLocation) {
            document.getElementById("toLatitude").value = toLocation.lat();
            document.getElementById("toLongitude").value = toLocation.lng();
        }
    }

    document.getElementById("fromAddress").addEventListener("keypress", function (e) {
        if (e.key === "Enter") e.preventDefault();
    });

    document.getElementById("toAddress").addEventListener("keypress", function (e) {
        if (e.key === "Enter") e.preventDefault();
    });
</script>


<script src="https://maps.googleapis.com/maps/api/js?key={{ $googleMapsApiKey }}&libraries=places&callback=initMap" async defer></script>
@endsection