@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="container">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3>Add-On Details</h3>

        <div>
            <a href="{{ route('admin.AddonManagement-index') }}"
               class="btn btn-secondary btn-sm">
                Back
            </a>

            <a href="{{ route('admin.AddonManagement-edit', $addon->id) }}"
               class="btn btn-warning btn-sm">
                Edit
            </a>
        </div>
    </div>

    <div class="row g-3">

        <!-- Name -->
        <div class="col-md-6">
            <div class="card border">
                <div class="card-body">
                    <small class="text-muted">Name</small>
                    <div class="fw-semibold">
                        {{ $addon->name }}
                    </div>
                </div>
            </div>
        </div>

        <!-- Price -->
        <div class="col-md-6">
            <div class="card border">
                <div class="card-body">
                    <small class="text-muted">Price</small>
                    <div class="fw-semibold">
                        ₹ {{ number_format($addon->price, 2) }}
                    </div>
                </div>
            </div>
        </div>

        <!-- Garment Types -->
        <div class="col-md-12">
            <div class="card border">
                <div class="card-body">
                    <small class="text-muted">Applicable Garment Types</small>
                    <div class="mt-1">
                        @foreach($addon->type_ids as $type)
                            <span class="badge bg-info text-dark me-1">
                                {{ $type }}
                            </span>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        <!-- Description -->
        <div class="col-md-12">
            <div class="card border">
                <div class="card-body">
                    <small class="text-muted">Description</small>
                    <div class="mt-1">
                        {{ $addon->description ?? '-' }}
                    </div>
                </div>
            </div>
        </div>

        <!-- Image -->
        <div class="col-md-12">
            <div class="card border">
                <div class="card-body">
                    <small class="text-muted">Reference Image</small>
                    <div class="mt-2">
                        @if($addon->image)
                            <img src="{{ asset('storage/'.$addon->image) }}"
                                 class="img-fluid rounded"
                                 style="max-height: 250px;">
                        @else
                            <span class="text-muted">No Image</span>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Created / Updated -->
        <div class="col-md-6">
            <div class="card border">
                <div class="card-body">
                    <small class="text-muted">Created At</small>
                    <div class="fw-semibold">
                        {{ $addon->created_at->format('d-m-Y h:i A') }}
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card border">
                <div class="card-body">
                    <small class="text-muted">Last Updated</small>
                    <div class="fw-semibold">
                        {{ $addon->updated_at->format('d-m-Y h:i A') }}
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection
