<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('roles', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->integer('role_admin_show')->default(1);
            $table->integer('priority_order')->default(1);
            $table->longText('menu_perm')->nullable();
            $table->longText('all_perm')->nullable();
            $table->integer('role_dashboard')->default(0);

            $table->string('name');
            $table->string('guard_name')->nullable();

            $table->integer('created_by')->default(0);
            $table->integer('updated_by')->default(0);

            $table->integer('deleted_status')->default(0);
            $table->integer('deleted_by')->default(0);

            $table->dateTime('deleted_at')->nullable();

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('roles');
    }
};
