<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('fare_summaries', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('booking_id')->unique();
            $table->unsignedBigInteger('driver_id');
            $table->string('customer_name');
            $table->string('car_type');
            $table->string('pickup_location');
            $table->string('drop_location');
            $table->decimal('total_km_travelled', 8, 2);
            $table->decimal('package_km', 8, 2);
            $table->decimal('extra_km_charged', 8, 2);
            $table->decimal('base_fare', 8, 2);
            $table->decimal('per_km_charge', 8, 2);
            $table->decimal('distance_fare', 8, 2);
            $table->decimal('waiting_charge', 8, 2);
            $table->decimal('total_price', 8, 2);
            $table->integer('travel_minutes');
            $table->time('start_time');
            $table->time('end_time');
            $table->timestamps();
        });
    }
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fare_summaries');
    }
};
