<?php
namespace App\Providers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\ServiceProvider;

class MenuServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        view()->composer('*', function ($view) {
            $user = auth()->user();
            // $user1 = Auth::user()->roles->pluck('id');
            // dd($user1);

            if ($user && $user->admin_roles) {
                $currentrole = $user->admin_roles;

                // dd($currentrole);
            } else {
                $currentrole = 0;
            }
            // dd($permissions = $user->getAllPermissions());
            $roles_menu_row = DB::table('roles')->where('id', $currentrole)->select('menu_perm')->first();

            // dd($roles_menu_row);

            $roles_menuid_impl_1 = ($roles_menu_row && $roles_menu_row->menu_perm) ? $roles_menu_row->menu_perm : "";
            $roles_menuid_arr    = ($roles_menuid_impl_1 != "") ? explode(",", $roles_menuid_impl_1) : ['0'];
            $roles_menuid_impl   = (count($roles_menuid_arr) > 0) ? "'" . implode("', '", $roles_menuid_arr) . "'" : "'0'";
            // dd($roles_menuid_arr);
            $admin_mainmenu_qry = DB::table('backend_menu_managament')->where('list_status', '1')->where('view_status', '1')
                ->where('p_id', '0')
                ->whereIn('id', $roles_menuid_arr);

            // dd($admin_mainmenu_qry);

            $admin_submenu_qry = DB::table('backend_menu_managament')->where('list_status', '1')
                ->where('view_status', '1')
                ->whereIn('id', $roles_menuid_arr)
                ->where('p_id', '!=', '0');

            if ($user && $user->adminpermissions) {

                $roles_menuid_impl_2 = $user->adminpermissions;
                $roles_menuid_arr_2  = ($roles_menuid_impl_2 != "") ? explode(",", $roles_menuid_impl_2) : ['0'];
                $roles_menuid_impl_2 = (count($roles_menuid_arr_2) > 0) ? "'" . implode("', '", $roles_menuid_arr_2) . "'" : "'0'";
                $admin_mainmenu_qry->whereIn('id', $roles_menuid_arr_2);
                $admin_submenu_qry->whereIn('id', $roles_menuid_arr_2);

            }

            $admin_mainmenu = $admin_mainmenu_qry
                ->orderBy('list_order', 'asc')->get();
            $admin_submenu = $admin_submenu_qry
                ->orderBy('list_order', 'asc')->get();

            // dd($admin_submenu);

            $admin_submenucount = DB::table('backend_menu_managament')->select(DB::raw('count(*) as user_count, p_id'))->groupBy('p_id')->where('list_status', '1')->where('view_status', '1')->orderBy('list_order', 'asc')->pluck('user_count', 'p_id')->toArray();

            // dd($admin_submenucount);

            $menudata = ["admin_mainmenu" => $admin_mainmenu, "admin_submenu" => $admin_submenu, "admin_submenucount" => $admin_submenucount, "currentrole" => $currentrole];

            $view->with('menudata', $menudata);

        });

    }
}
