<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\ACommonController;
use Google\Auth\Credentials\ServiceAccountCredentials;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class TestController extends ACommonController
{
    public function test()
    {
        $credentialsPath = storage_path('app/public/firebase/service-account.json');

        $scopes = ['https://www.googleapis.com/auth/firebase.messaging'];

        $credentials = new ServiceAccountCredentials($scopes, $credentialsPath);

        $accessTokenData = $credentials->fetchAuthToken();

        if (! isset($accessTokenData['access_token'])) {
            return response()->json([
                'success'  => false,
                'message'  => 'Failed to retrieve access token',
                'response' => $accessTokenData,
            ], 500);
        }

        $accessToken = $accessTokenData['access_token'];

        $projectId = json_decode(file_get_contents($credentialsPath), true)['project_id'];

        $payload = [
            'message' => [
                'token'        => 'DB0ED72F-5798-4594-9130-1115A9386AC2', // Replace with real device token
                'notification' => [
                    'title' => 'Hello from Firebase',
                    'body'  => 'FCM v1 API working!',
                ],
            ],
        ];

        $response = Http::withToken($accessToken)
            ->post("https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send", $payload);

        return response()->json([
            'success'  => $response->successful(),
            'message'  => $response->successful() ? 'Notification sent' : 'Failed to send notification',
            'response' => $response->json(),
        ]);
    }

    public function test1()
    {
        $credentialsPath = storage_path('app/public/firebase/service-account.json'); // Path to your key file

        $credentials = new ServiceAccountCredentials(
            'https://www.googleapis.com/auth/firebase.messaging',
            json_decode(file_get_contents($credentialsPath), true)
        );

        $accessToken = $credentials->fetchAuthToken()['access_token'];

        $projectId = 'vaigaitaxi';

        $payload = [
            'message' => [
                'token'        => 'YOUR_DEVICE_TOKEN',
                'notification' => [
                    'title' => 'Hello from HTTP v1',
                    'body'  => 'This is using OAuth2 access token',
                ],
            ],
        ];

        $response = Http::withToken($accessToken)
            ->post("https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send", $payload);

        return $response->json();

    }

    public function test2()
    {

        // Example Firebase token (replace with a real token from your device)
        $firebaseToken = 'DB0ED72F-5798-4594-9130-1115A9386AC2';

        $payload = [
            'to'           => $firebaseToken,
            'notification' => [
                'title' => 'Test Notification',
                'body'  => 'This is a test push notification from Laravel using Firebase',
                'sound' => 'default',
            ],
            'data'         => [
                'custom_key' => 'custom_value',
                'screen'     => 'test_screen',
            ],
        ];

        $response = Http::withHeaders([
            'Authorization' => 'key=' . config('services.fcm.server_key'),
            'Content-Type'  => 'application/json',
        ])->post('https://fcm.googleapis.com/fcm/send', $payload);

        if ($response->successful()) {
            return response()->json([
                'success'  => true,
                'message'  => 'Notification sent successfully',
                'response' => $response->json(),
            ]);
        } else {
            Log::error('FCM Push Failed', [
                'token'    => $firebaseToken,
                'response' => $response->body(),
            ]);

            return response()->json([
                'success'  => false,
                'message'  => 'Failed to send notification',
                'response' => $response->body(),
            ], 500);
        }
    }

    public function test3()
    {

        $expoPushToken = 'ExponentPushToken[UyQiMBElLk8xT5D-GGcsUm]';

        $response = Http::post('https://exp.host/--/api/v2/push/send', [
            'to'    => $expoPushToken,
            'sound' => 'default',
            'title' => 'Test Notification from Laravel',
            'body'  => 'This is a test notification sent by ExpoPushTestController',
            'data'  => ['extraData' => 'Some extra data'],
        ]);

        if ($response->successful()) {
            return response()->json([
                'status'   => 'success',
                'message'  => 'Notification sent',
                'response' => $response->json(),
            ]);
        }

        return response()->json([
            'status'   => 'error',
            'message'  => 'Failed to send notification',
            'response' => $response->json(),
        ], 500);
    }

}
