<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Expense;
use Illuminate\Http\Request;

class ExpenseManagementController extends Controller
{
    public function index()
    {
        $expenses = Expense::latest()->paginate(10);
        return view('admin.expense_management.index', compact('expenses'));
    }

    public function create()
    {
        return view('admin.expense_management.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'amount' => 'required|numeric|min:1',
            'expense_date' => 'required|date',
        ]);

        Expense::create($request->all());

        return redirect()
            ->route('admin.ExpenseManagement-index')
            ->with('success', 'Expense added');
    }
}

