<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Request;

class ACommonController extends Controller
{

    public function createlog($userid, $pagename, $loginfo)
    {
        $dateTime                 = date('Y-m-d H:i:s');
        $logdata                  = [];
        $logdata['login_user']    = $userid;
        $logdata['page_name']     = $pagename;
        $logdata['log_info']      = $loginfo;
        $logdata['log_date']      = $dateTime;
        $logdata['log_status']    = 1;
        $logdata['log_ipaddress'] = Request::ip();
        DB::table('log_reports')->insertGetId($logdata);
    }

    public function uploadarr_frmimg($request, $path, $name, $size = '2097152', $prefix = "img")
    {

        $uploadDataArray = $request->{$name};
        $resultarr       = [];
        if ($request && $request->hasFile($name)) {
            $allowedextention = ["image/jpeg", "image/pjpeg", "image/jpg", "image/png"];

            foreach ($uploadDataArray as $key => $imgRow) {
                // dd($request->file($name)[$key]->getClientOriginalName());

                if (in_array($request->file($name)[$key]->getClientMimeType(), $allowedextention)) {
                    if ($request->file($name)[$key]->getSize() <= $size) {
                        $trans_r    = 255;
                        $trans_g    = 255;
                        $trans_b    = 255;
                        $cache_fs   = $path;
                        $cache_uri  = '';
                        $srid       = md5($_SERVER['REMOTE_ADDR'] . $_SERVER['REMOTE_PORT'] . time()) . rand(1000, 9999);
                        $filetypexp = $request->file($name)[$key]->extension();
                        $fileName   = pathinfo($request->file($name)[$key]->getClientOriginalName(), PATHINFO_FILENAME);

                        $file_name_modified = preg_replace('/[^A-Za-z0-9]/', '', $prefix) . "_" . substr(preg_replace('/[^A-Za-z0-9]/', '', $fileName), 0, 20);
                        $base_fs            = $cache_fs . $file_name_modified . $srid . '.' . $filetypexp;
                        $base_uri           = $file_name_modified . $srid . '.' . $filetypexp;
                        if ($request->file($name)[$key]->storeAs($cache_fs, $base_uri)) {
                            $resultarr[$key] = $base_uri;
                        }
                    }
                }
            }
        }
        return $resultarr;
    }

    public function generatefarmerbuyerinvoicenumber($auction_id)
    {

        $getauction_managements = DB::table('auctions_managements')
            ->where('id', $auction_id)
            ->first();

        $getauction_details = DB::table('auctions_details')
            ->join('entry_details', 'auctions_details.entry_detail_id', '=', 'entry_details.id')
            ->join('products', 'entry_details.product_id', '=', 'products.id')
            ->join('all_fields as measurement', 'products.measurement', '=', 'measurement.id')
            ->where('auctions_details.auction_id', $auction_id)
            ->select(
                'auctions_details.*',
                'auctions_details.farmer_price as fp',
                'entry_details.farmer_id',
                'entry_details.id as entry_detail_id',
                'measurement.tbl_name as measurement_name'
            )
            ->get();

        $inserted_buyer  = [];
        $inserted_farmer = [];

        foreach ($getauction_details as $auction_details) {

            // ----------------------------------- Farmer Invoice--------------------------------------

            $farmer_invoice_details_exist = DB::table('invoice_masters')
                ->where('type', 1)
                ->where('farmerbuyerid', $auction_details->farmer_id)
                ->where('invoice_date', $getauction_managements->date)
                ->first();

            if ($farmer_invoice_details_exist) {

                $farmer_invoice_order_num = $farmer_invoice_details_exist->invoice_order_num;

                $farmer_invoice_number = $farmer_invoice_details_exist->invoice_number;

                $farmer_invoice_master_id = $farmer_invoice_details_exist->id;

            } else {

                $farmer_prefix = 'InvF';

                $farmer_lastNumber        = DB::table('invoice_masters')->where('type', '=', 1)->max('invoice_order_num');
                $farmer_invoice_order_num = ($farmer_lastNumber > 0) ? $farmer_lastNumber + 1 : 1;

                $farmer_invoice_number = $farmer_prefix . str_pad($farmer_invoice_order_num, 5, '0', STR_PAD_LEFT);

                $farmer_invoice_master_id = DB::table('invoice_masters')->insertGetId(
                    [

                        'invoice_date'        => $getauction_managements->date,
                        'type'                => 1,
                        'refer_type'          => 1,
                        'farmerbuyerid'       => $auction_details->farmer_id,
                        'invoice_number'      => $farmer_invoice_number,
                        'invoice_order_num'   => $farmer_invoice_order_num,
                        'ori_inv_amount'      => $auction_details->farmer_sellamount,
                        'new_orignal_inv_amt' => $auction_details->farmer_sellamount,
                        'unit_price'          => $auction_details->unit_price,
                        'farmer_price'        => $auction_details->farmer_price,

                    ]
                );

            }

            if ($farmer_invoice_master_id > 0) {

                DB::table('auctions_details')
                    ->where('id', $auction_details->id)
                    ->update([

                        'farmer_invoice_id' => $farmer_invoice_master_id,

                    ]);

                $invoice_farmer = DB::table('invoice_details')->insertGetId(
                    [

                        'invoice_master_id'   => $farmer_invoice_master_id,
                        'auction_id'          => $auction_details->auction_id,
                        'entryorauction_date' => $getauction_managements->date,
                        'type'                => 1,
                        'entry_id'            => $auction_details->entry_detail_id,
                        'amount'              => $auction_details->farmer_sellamount,
                        'f_amount'            => $auction_details->farmer_price,
                        'c_amount'            => 0,
                        'unit_price'          => $auction_details->unit_price,
                        'farmer_price'        => $auction_details->farmer_price,

                    ]
                );

                $inserted_farmer[] = $farmer_invoice_master_id;

                foreach ($inserted_farmer as $farmer_invoice_id) {

                    if ($farmer_invoice_id > 0) {

                        $this->calculatedamount_farmer($farmer_invoice_id);

                    }

                }

                $this->farmer_finalamount($farmer_invoice_master_id);

            }

            //---------------------------------- Buyer Invoice----------------------------------------

            $buyer_invoice_details_exist = DB::table('invoice_masters')
                ->where('type', 2)
                ->where('farmerbuyerid', $auction_details->buyer_id)
                ->where('invoice_date', $getauction_managements->date)
                ->first();

            if ($buyer_invoice_details_exist) {

                $buyer_invoice_order_num = $buyer_invoice_details_exist->invoice_order_num;

                $buyer_invoice_number = $buyer_invoice_details_exist->invoice_number;

                $buyer_invoice_master_id = $buyer_invoice_details_exist->id;

            } else {

                $buyer_prefix = 'InvB';

                $buyer_lastNumber        = DB::table('invoice_masters')->where('type', '=', 2)->max('invoice_order_num');
                $buyer_invoice_order_num = ($buyer_lastNumber > 0) ? $buyer_lastNumber + 1 : 1;

                $buyer_invoice_number = $buyer_prefix . str_pad($buyer_invoice_order_num, 5, '0', STR_PAD_LEFT);

                // if ($auction_details->measurement_name == 'KG') {
                //     // dd($auction_details->measurement_name);

                //     $invoice_amount = $auction_details->weight * $auction_details->unit_price;
                // } else {

                //     $invoice_amount = $auction_details->sell_tray * $auction_details->unit_price;
                // }

                $buyer_invoice_master_id = DB::table('invoice_masters')->insertGetId(
                    [

                        'invoice_date'        => $getauction_managements->date,
                        'type'                => 2,
                        'refer_type'          => 1,
                        'farmerbuyerid'       => $auction_details->buyer_id,
                        'invoice_number'      => $buyer_invoice_number,
                        'invoice_order_num'   => $buyer_invoice_order_num,
                        'ori_inv_amount'      => $auction_details->buyer_sellamount,
                        'new_orignal_inv_amt' => $auction_details->buyer_sellamount,
                        'unit_price'          => $auction_details->unit_price,
                        'buyer_price'         => $auction_details->buyer_price,

                    ]
                );

            }
            //---------------------------------- Buyer Invoice----------------------------------------
            if ($buyer_invoice_master_id > 0) {

                DB::table('auctions_details')
                    ->where('id', $auction_details->id)
                    ->update([

                        'buyer_invoice_id' => $buyer_invoice_master_id,

                    ]);

                $invoice_buyer = DB::table('invoice_details')->insertGetId(
                    [

                        'invoice_master_id'   => $buyer_invoice_master_id,
                        'entry_id'            => $auction_details->entry_detail_id,
                        'auction_id'          => $auction_details->auction_id,
                        'entryorauction_date' => $getauction_managements->date,
                        'type'                => 2,
                        'amount'              => $auction_details->buyer_sellamount,
                        'unit_price'          => $auction_details->unit_price,
                        'b_amount'            => $auction_details->buyer_price,

                    ]
                );

                $inserted_buyer[] = $buyer_invoice_master_id;

                foreach ($inserted_buyer as $buyer_invoice_id) {

                    if ($buyer_invoice_id > 0) {
                        $this->calculatedamount_buyer($buyer_invoice_id);
                    }

                }

                $this->buyer_finalamount($buyer_invoice_master_id);

            }

        }

        Log::info('Auction Detail: ' . json_encode($auction_details));
        // dd($inserted_farmer);
        // dd($inserted_buyer);

    }

    public function calculatedamount_farmer($farmer_invoiceid)
    {
        $dateTime = date('Y-m-d H:i:s');

        $farmer_amounts = DB::table('auctions_details')
            ->join('entry_details', 'auctions_details.entry_detail_id', '=', 'entry_details.id')
            ->join('products', 'entry_details.product_id', '=', 'products.id')
            ->join('all_fields as measurement', 'products.measurement', '=', 'measurement.id')
            ->where('farmer_invoice_id', $farmer_invoiceid) // Matching the auctions_details.id
            ->select(
                'auctions_details.*',
                'measurement.tbl_name as measurement_name',
                DB::raw('sell_amount as t_sell_amount'),
                DB::raw('unit_price as total_unit_price'),
                DB::raw('farmer_sellamount as farmer_sell_amount'),
                DB::raw('farmer_price as total_fp'),

            )
            ->get();

        foreach ($farmer_amounts as $farmer_amount) {

            if ($farmer_amount) {
                if ($farmer_amount->measurement_name == 'KG') {
                    $sell_amount       = $farmer_amount->weight * $farmer_amount->total_unit_price;
                    $farmer_sellamount = $farmer_amount->weight * $farmer_amount->total_fp;
                } elseif ($farmer_amount->measurement_name == 'UNIT') {
                    $sell_amount       = $farmer_amount->sell_tray * $farmer_amount->total_unit_price;
                    $farmer_sellamount = $farmer_amount->sell_tray * $farmer_amount->total_fp;

                }

            }

            DB::table('auctions_details')
                ->where('id', $farmer_amount->id)
                ->update([
                    'sell_amount'       => $sell_amount,
                    'farmer_sellamount' => $farmer_sellamount,
                    'updated_at'        => $dateTime,

                ]);

        }

        $sell_amount_sum = DB::table('auctions_details')
            ->where('farmer_invoice_id', $farmer_invoiceid)
            ->sum('sell_amount');
        $fp_sell_amount_sum = DB::table('auctions_details')
            ->where('farmer_invoice_id', $farmer_invoiceid)
            ->sum('farmer_sellamount');

        // dd($sell_amount_sum);
        // dd($fp_sell_amount_sum);

        $update_im = DB::table('invoice_masters')
            ->where('type', 1)
            ->where('id', $farmer_invoiceid)
            ->update([
                'ori_inv_amount'      => $sell_amount_sum,
                'new_orignal_inv_amt' => $sell_amount_sum,
                'farmer_inv_amount'   => $fp_sell_amount_sum,
                // 'final_inv_amount'    => $sell_amount_sum,
                // 'unit_price' => $sell_amount,
                // 'updated_at'          => $dateTime,

            ]);

        // dd($update_im);

    }

    public function calculatedamount_buyer($buyer_invoiceid)
    {

        $dateTime = date('Y-m-d H:i:s');

        $buyer_amounts = DB::table('auctions_details')
            ->join('entry_details', 'auctions_details.entry_detail_id', '=', 'entry_details.id')
            ->join('products', 'entry_details.product_id', '=', 'products.id')
            ->join('all_fields as measurement', 'products.measurement', '=', 'measurement.id')
            ->where('auctions_details.buyer_invoice_id', $buyer_invoiceid)

            ->select(
                'auctions_details.*',
                'measurement.tbl_name as measurement_name',
                DB::raw('auctions_details.sell_amount as t_sell_amount'),
                DB::raw('auctions_details.unit_price as total_unit_price'),
                DB::raw('auctions_details.buyer_sellamount as buyer_sell_amount'),
                DB::raw('auctions_details.buyer_price as total_bp')

            )
            ->get();

        foreach ($buyer_amounts as $buyer_amount) {

            if ($buyer_amount) {

                if ($buyer_amount->measurement_name == 'KG') {

                    $sell_amount      = $buyer_amount->weight * $buyer_amount->total_unit_price;
                    $buyer_sellamount = $buyer_amount->weight * $buyer_amount->total_bp;

                } elseif ($buyer_amount->measurement_name == 'UNIT') {

                    $sell_amount      = $buyer_amount->sell_tray * $buyer_amount->total_unit_price;
                    $buyer_sellamount = $buyer_amount->sell_tray * $buyer_amount->total_bp;
                    // echo "2_" . $buyer_amount->sell_tray . "-" . $buyer_amount->total_unit_price . "-" . $buyer_amount->total_bp;
                    // echo "<br> 2_" . $buyer_sellamount . "<br>";

                }
                // echo "<br>" . $buyer_invoiceid . "<br>";
                // echo "<br>" . $buyer_amount->id . "<hr>";
            }

            DB::table('auctions_details')
                ->where('id', $buyer_amount->id)
                ->update([
                    'sell_amount'      => $sell_amount,
                    'buyer_sellamount' => $buyer_sellamount,
                    'updated_at'       => $dateTime,

                ]);

        }

        // exit();

        $sell_amount_sum = DB::table('auctions_details')
            ->where('buyer_invoice_id', $buyer_invoiceid)
            ->sum('sell_amount');

        $bp_sell_amount_sum = DB::table('auctions_details')
            ->where('buyer_invoice_id', $buyer_invoiceid)
            ->sum('buyer_sellamount');

        DB::table('invoice_masters')
            ->where('type', 2)
            ->where('id', $buyer_invoiceid)
            ->update([

                'ori_inv_amount'      => $sell_amount_sum,
                'new_orignal_inv_amt' => $sell_amount_sum,
                'buyer_inv_amount'    => $bp_sell_amount_sum,
                // 'final_inv_amount' => $sell_amount,
                // 'unit_price' => $sell_amount,
                // 'updated_at' => $dateTime,

            ]);

    }

    public function edit_generatefarmerbuyerinvoicenumber($auction_id)
    {

        $getauction_managements = DB::table('auctions_managements')
            ->where('id', $auction_id)
            ->first();

        $getauction_details = DB::table('auctions_details')
            ->join('entry_details', 'auctions_details.entry_detail_id', '=', 'entry_details.id')
            ->where('auctions_details.auction_id', $auction_id)
            ->where(function ($qry) {
                $qry->where('auctions_details.farmer_invoice_id', 0);
                $qry->orWhere('auctions_details.buyer_invoice_id', 0);
            })->select(
            'auctions_details.*',
            'entry_details.farmer_id',
            'entry_details.id as entry_detail_id')
            ->get();
        $inserted_buyer  = [];
        $inserted_farmer = [];

        foreach ($getauction_details as $auction_details) {

            //----------------------------------Edit Farmer Invoice----------------------------------------

            $farmer_invoice_details_exist = DB::table('invoice_masters')
                ->where('type', 1)
                ->where('farmerbuyerid', $auction_details->farmer_id)
                ->where('invoice_date', $getauction_managements->date)
                ->first();

            if ($farmer_invoice_details_exist) {

                $farmer_invoice_order_num = $farmer_invoice_details_exist->invoice_order_num;

                $farmer_invoice_number = $farmer_invoice_details_exist->invoice_number;

                $farmer_invoice_master_id = $farmer_invoice_details_exist->id;

            } else {

                $farmer_prefix = 'InvF';

                $farmer_lastNumber        = DB::table('invoice_masters')->where('type', '=', 1)->max('invoice_order_num');
                $farmer_invoice_order_num = ($farmer_lastNumber > 0) ? $farmer_lastNumber + 1 : 1;

                $farmer_invoice_number = $farmer_prefix . str_pad($farmer_invoice_order_num, 5, '0', STR_PAD_LEFT);

                $farmer_invoice_master_id = DB::table('invoice_masters')->insertGetId(
                    [

                        'invoice_date'        => $getauction_managements->date,
                        'type'                => 1,
                        'refer_type'          => 1,
                        'farmerbuyerid'       => $auction_details->farmer_id,
                        'invoice_number'      => $farmer_invoice_number,
                        'invoice_order_num'   => $farmer_invoice_order_num,
                        'ori_inv_amount'      => $auction_details->farmer_sellamount,
                        'new_orignal_inv_amt' => $auction_details->farmer_sellamount,
                        'unit_price'          => $auction_details->unit_price,
                        'farmer_price'        => $auction_details->farmer_price,
                        'farmer_inv_amount'   => $auction_details->farmer_sellamount,

                    ]
                );

            }

            if ($farmer_invoice_master_id > 0) {

                DB::table('auctions_details')
                    ->where('id', $auction_details->id)
                    ->update([

                        'farmer_invoice_id' => $farmer_invoice_master_id,

                    ]);

                $invoice_farmer = DB::table('invoice_details')->insertGetId(
                    [

                        'invoice_master_id'   => $farmer_invoice_master_id,
                        'auction_id'          => $auction_details->auction_id,
                        'entryorauction_date' => $getauction_managements->date,
                        'type'                => 1,
                        'entry_id'            => $auction_details->entry_detail_id,
                        'amount'              => $auction_details->farmer_sellamount,
                        'unit_price'          => $auction_details->unit_price,
                        'farmer_price'        => $auction_details->farmer_price,

                    ]
                );

                $inserted_farmer[] = $farmer_invoice_master_id;

            }

            foreach ($inserted_farmer as $farmer_invoice_id) {

                if ($farmer_invoice_id > 0) {

                    $this->calculatedamount_farmer($farmer_invoice_id);

                }

            }

            //----------------------------------Edit  Buyer Invoice----------------------------------------

            $buyer_invoice_details_exist = DB::table('invoice_masters')
                ->where('type', 2)
                ->where('farmerbuyerid', $auction_details->buyer_id)
                ->where('invoice_date', $getauction_managements->date)
                ->first();

            if ($buyer_invoice_details_exist) {

                $buyer_invoice_order_num = $buyer_invoice_details_exist->invoice_order_num;

                $buyer_invoice_number = $buyer_invoice_details_exist->invoice_number;

                $buyer_invoice_master_id = $buyer_invoice_details_exist->id;

            } else {

                $buyer_prefix = 'InvB';

                $buyer_lastNumber        = DB::table('invoice_masters')->where('type', '=', 2)->max('invoice_order_num');
                $buyer_invoice_order_num = ($buyer_lastNumber > 0) ? $buyer_lastNumber + 1 : 1;

                $buyer_invoice_number = $buyer_prefix . str_pad($buyer_invoice_order_num, 5, '0', STR_PAD_LEFT);

                $buyer_invoice_master_id = DB::table('invoice_masters')->insertGetId(
                    [

                        'invoice_date'        => $getauction_managements->date,
                        'type'                => 2,
                        'refer_type'          => 1,
                        'farmerbuyerid'       => $auction_details->buyer_id,
                        'invoice_number'      => $buyer_invoice_number,
                        'invoice_order_num'   => $buyer_invoice_order_num,
                        'ori_inv_amount'      => $auction_details->buyer_sellamount,
                        'new_orignal_inv_amt' => $auction_details->buyer_sellamount,
                        'unit_price'          => $auction_details->unit_price,
                        'buyer_price'         => $auction_details->buyer_price,
                        'buyer_inv_amount'    => $auction_details->buyer_sellamount,

                    ]
                );

            }

            if ($buyer_invoice_master_id > 0) {

                DB::table('auctions_details')
                    ->where('id', $auction_details->id)
                    ->update([

                        'buyer_invoice_id' => $buyer_invoice_master_id,

                    ]);

                $invoice_buyer = DB::table('invoice_details')->insertGetId(
                    [

                        'invoice_master_id'   => $buyer_invoice_master_id,
                        'entry_id'            => $auction_details->entry_detail_id,
                        'auction_id'          => $auction_details->auction_id,
                        'entryorauction_date' => $getauction_managements->date,
                        'type'                => 2,
                        'amount'              => $auction_details->buyer_sellamount,
                        'unit_price'          => $auction_details->unit_price,
                        'buyer_price'         => $auction_details->buyer_price,

                    ]
                );

                $inserted_buyer[] = $buyer_invoice_master_id;

                foreach ($inserted_buyer as $buyer_invoice_id) {

                    if ($buyer_invoice_id > 0) {
                        $this->calculatedamount_buyer($buyer_invoice_id);

                    }

                }

            }

        }

        $auction_details_farmer = DB::table('auctions_details')
            ->where('auction_id', $auction_id)
            ->where('farmer_invoice_id', '>', 0)
            ->selectRaw('auctions_details.farmer_invoice_id,SUM(farmer_sellamount) as total_sell_amount,SUM(unit_price) as total_unit_price,auctions_details.farmer_price,auctions_details.farmer_sellamount')
            ->groupBy('farmer_invoice_id')
            ->get();

        foreach ($auction_details_farmer as $farmer_edit) {

            $invoice_farmer = DB::table('invoice_masters')->where('id', $farmer_edit->farmer_invoice_id)->first();

            if ($invoice_farmer) {

                $update_invoice_farmer = DB::table('invoice_masters')
                    ->where('id', $farmer_edit->farmer_invoice_id)
                    ->update(
                        [
                            'ori_inv_amount'      => $farmer_edit->total_sell_amount,
                            'new_orignal_inv_amt' => $farmer_edit->total_sell_amount,
                            'unit_price'          => $farmer_edit->total_unit_price,
                            'farmer_price'        => $farmer_edit->farmer_price,
                            'farmer_inv_amount'   => $farmer_edit->total_sell_amount,

                        ]
                    );
            }

        }

        $auction_details_buyer = DB::table('auctions_details')
            ->where('auction_id', $auction_id)
            ->where('buyer_invoice_id', '>', 0)
            ->selectRaw('auctions_details.buyer_invoice_id,SUM(buyer_sellamount) as total_sell_amount,SUM(unit_price) as total_unit_price,auctions_details.buyer_price,auctions_details.buyer_sellamount')
            ->groupBy('buyer_invoice_id')
            ->get();

        foreach ($auction_details_buyer as $buyer_edit) {

            $invoice_buyer = DB::table('invoice_masters')->where('id', $buyer_edit->buyer_invoice_id)->first();

            if ($invoice_buyer) {

                $update_invoice_buyer = DB::table('invoice_masters')
                    ->where('id', $buyer_edit->buyer_invoice_id)
                    ->update(
                        [
                            'ori_inv_amount'      => $buyer_edit->total_sell_amount,
                            'new_orignal_inv_amt' => $buyer_edit->total_sell_amount,
                            'unit_price'          => $buyer_edit->total_unit_price,
                            'buyer_price'         => $buyer_edit->buyer_price,
                            'buyer_inv_amount'    => $buyer_edit->total_sell_amount,

                        ]
                    );
            }

        }

        // dd($auction_details_farmer, $auction_details_buyer);

        // dd($update_invoice_farmer, $update_invoice_buyer);

    }

    public function farmer_finalamount($invoice_masterid)
    {

        $recordQry = DB::table('invoice_masters')
            ->join('farmers', 'invoice_masters.farmerbuyerid', '=', 'farmers.id')
            ->join('auctions_details', 'invoice_masters.id', '=', 'auctions_details.farmer_invoice_id')
            ->join('auctions_managements', 'auctions_details.auction_id', '=', 'auctions_managements.id')
            ->join('entry_details', 'auctions_details.entry_detail_id', '=', 'entry_details.id')
            ->join('vehicles', 'entry_details.vehicle_id', '=', 'vehicles.id')
            ->join('products', 'entry_details.product_id', '=', 'products.id')
            ->join('all_fields as quality', 'products.product_quality', '=', 'quality.id')
            ->join('all_fields as measurement', 'products.measurement', '=', 'measurement.id')
            ->where('invoice_masters.id', $invoice_masterid)

            ->select(
                'invoice_masters.invoice_date as Date',
                'invoice_masters.invoice_number as InvoicNumber',
                'farmers.farmer_name as name',
                'invoice_masters.farmerbuyerid as farmer_id',
                'quality.tbl_name as quality',
                'measurement.tbl_name as Measurement',
                'auctions_details.sell_amount as SellAmount',
                'auctions_details.farmer_sellamount as Amount',
                'auctions_details.unit_price as Unit_price',
                'invoice_masters.ori_inv_amount as original_invamt',
                'invoice_masters.farmer_inv_amount as buyer_inv_amount',
                DB::raw('SUM(auctions_details.sell_tray) as Selled_tray_sum'),
                'auctions_details.weight as weight',
                // 'products.purchase_commission as pc',
                'products.sales_commission as sc',
                'products.loading_charge as lc',
                // 'products.unloading_charge as unlc',
                'vehicles.rent as rent',
                DB::raw("CONCAT(products.product_name) as product_name")
            )
            ->first();

        //dd($recordQry);

        $originalInvAmt = $recordQry->original_invamt;

        $sales_commission = $recordQry->sc;
        $loadingCharge    = $recordQry->lc;
        $rent             = $recordQry->rent;

        $selledTraySum = $recordQry->Selled_tray_sum;

        $sales_commissionAmount = ($sales_commission / 100) * $originalInvAmt;

        $rentPerTray = ($selledTraySum != 0) ? $rent * $selledTraySum : 0;

        $loadingChargePerTray = ($selledTraySum != 0) ? $loadingCharge * $selledTraySum : 0;

        $total_expense = $sales_commissionAmount + $rentPerTray + $loadingChargePerTray;

        $newInvAmt = $originalInvAmt - ($sales_commissionAmount + $rentPerTray + $loadingChargePerTray);

        $newInvAmt = number_format((float) $newInvAmt, 2, '.', '');
        // dd($sales_commission, $rentPerTray, $loadingChargePerTray, $newInvAmt);

        $farmer_invoice = DB::table('invoice_masters')
            ->where('id', $invoice_masterid)
            ->update([
                'purchase_commission' => $sales_commission,
                'commission_charge'   => $sales_commissionAmount,
                'labour_charge'       => $loadingChargePerTray,
                'rent_charge'         => $rentPerTray,
                'final_inv_amount'    => $newInvAmt,
                'new_final_amount'    => $newInvAmt,
                'new_final_amount'    => $newInvAmt,
                'farmer_inv_amount'   => $newInvAmt,
                'total_expense'       => $total_expense,

            ]);

        $farmer_id = $recordQry->farmer_id;
        $amount    = 0 - $newInvAmt;
        $dateTime  = date('Y-m-d H:i:s');

        // $report_insrec = DB::table('report')->insertGetId(
        //     [
        //         'fb_type' => 1,
        //         'fb_id' => $farmer_id,
        //         'transaction_type' => 2,
        //         'amount_type' => 2,
        //         'd_amount' => $newInvAmt,

        //         'amount' => $amount,
        //         'bal_amount' => $amount,
        //         'created_at' => $dateTime,
        //         'updated_at' => $dateTime,

        //     ]
        // );

    }
    public function buyer_finalamount($invoice_masterid)
    {

        $recordQry = DB::table('invoice_masters')
            ->join('buyer', 'invoice_masters.farmerbuyerid', '=', 'buyer.id')
            ->join('auctions_details', 'invoice_masters.id', '=', 'auctions_details.buyer_invoice_id')
            ->join('auctions_managements', 'auctions_details.auction_id', '=', 'auctions_managements.id')
            ->join('entry_details', 'auctions_details.entry_detail_id', '=', 'entry_details.id')
            ->join('vehicles', 'entry_details.vehicle_id', '=', 'vehicles.id')
            ->join('products', 'entry_details.product_id', '=', 'products.id')
            ->join('all_fields as quality', 'products.product_quality', '=', 'quality.id')
            ->join('all_fields as measurement', 'products.measurement', '=', 'measurement.id')
            ->where('invoice_masters.id', $invoice_masterid)
            ->select(
                'invoice_masters.invoice_date as Date',
                'invoice_masters.invoice_number as InvoicNumber',
                'buyer.buyer_name as name',
                'quality.tbl_name as quality',
                'measurement.tbl_name as Measurement',
                'auctions_details.sell_amount as SellAmount',
                'auctions_details.buyer_sellamount as Amount',
                'auctions_details.unit_price as Unit_price',
                'invoice_masters.ori_inv_amount as original_invamt',
                'invoice_masters.buyer_inv_amount as buyer_inv_amount',
                DB::raw('SUM(auctions_details.sell_tray) as Selled_tray_sum'),
                'auctions_details.weight as weight',
                'products.purchase_commission as pc',
                // 'products.sales_commission as sc',
                'products.loading_charge as lc',
                'products.unloading_charge as unlc',
                'vehicles.rent as rent',
                DB::raw("CONCAT(products.product_name) as product_name")
            )
            ->first();
        // Log::info($recordQry->original_invamt . "Calculation FN");
        $originalInvAmt     = $recordQry->original_invamt;
        $purchaseCommission = $recordQry->pc;
        $rent               = $recordQry->rent;
        $loadingCharge      = $recordQry->lc;
        $unloadingCharge    = $recordQry->unlc;
        $selledTraySum      = $recordQry->Selled_tray_sum;

        // dd("Purchase Commission: $purchaseCommission", "Rent: $rent", "Loading Charge: $loadingCharge");

        $purchaseCommissionAmount = round(($purchaseCommission / 100) * $originalInvAmt, 2);
        $rentPerTray              = 0;
        $loadingChargePerTray     = 0;

        // dd("Purchase Commission: $purchaseCommissionAmount", "Rent: $rentPerTray", "Loading Charge: $loadingChargePerTray");

        $total_expense = $purchaseCommissionAmount + $rentPerTray + $loadingChargePerTray;

        $newInvAmt = $originalInvAmt + $total_expense;

        // dd("originalInvAmt -" . $originalInvAmt,
        //     "Purchase Commission: $purchaseCommission",
        //     "purchaseCommissionAmount -" . $purchaseCommissionAmount,
        //     "rentPerTray -" . $rentPerTray,
        //     "loadingChargePerTray -" . $loadingCharge,
        //     "total_expense -" . $total_expense,
        //     "newInvAmt -" . $newInvAmt);

        $buyer_invoice = DB::table('invoice_masters')
            ->where('id', $invoice_masterid)
            ->update([
                'purchase_commission' => $purchaseCommission,
                // 'loading_charge_per_tray' => $loadingCharge,
                // 'rent_per_tray' => $rent,
                'commission_charge'   => $purchaseCommissionAmount,
                'labour_charge'       => $loadingChargePerTray,
                'rent_charge'         => $rentPerTray,
                'final_inv_amount'    => $newInvAmt,
                'new_final_amount'    => $newInvAmt,
                'buyer_inv_amount'    => $newInvAmt,
                'total_expense'       => $total_expense,
            ]);

    }

    public function invoice_cash(Request $request, $invoice_masterid)
    {

        $invoice_masterRow = DB::table('invoice_masters')->where('id', $invoice_masterid)->first();
        // dd($invoice_masterRow);

        $cash_id = $invoice_masterRow->cash_id;

        if ($cash_id > 0) {
            $cash_managementRow = DB::table('cash_management')
                ->where('id', $cash_id)->update([
                'payment_type'    => $request->input('online_handcash'),
                'payed_amount'    => $request->input('payed_amount'),
                'discount_amount' => $request->input('discount_amount'),
            ]);
            return redirect()->back()->with('success', 'Payment updated successfully.');
        } else {
            DB::table('cash_management')->create([
                'payment_type'    => $request->input('online_handcash'),
                'payed_amount'    => $request->input('payed_amount'),
                'discount_amount' => $request->input('discount_amount'),
                // Add other necessary fields (e.g., 'invoice_id' if needed)
            ]);
            return redirect()->back()->with('success', 'Payment saved successfully.');
        }

        // dd($cash_managementRow);

    }

}
